if (name_input_active) {
    // Iegūst tastatūras ievadi
    global.player_name = keyboard_string;

    // Apstiprina vārda ievadi ar Enter taustiņu
    if (keyboard_check_pressed(vk_enter)) {
        name_input_active = false; // Iziet no ievades režīma
        room_goto(rm_level1); // Turpināt spēli
    }

    // Ļauj atcelt ievadi ar Escape taustiņu
    if (keyboard_check_pressed(vk_escape)) {
        name_input_active = false; // Iziet no ievades režīma
        global.player_name = ""; // Atiestatīt vārdu, ja atcelts
    }
} else {
    // Ievades apstrāde izvēlnes navigācijai
    up_key = keyboard_check_pressed(vk_up);
    down_key = keyboard_check_pressed(vk_down);
    accept_key = keyboard_check_pressed(vk_enter);

    // Iegūst opciju skaitu pašreizējā izvēlnē
    op_length = array_length(option[menu_level]);

    // Navigācija pa izvēlni
    pos += down_key - up_key;
    if (menu_level == 6) {
        if (pos < 1) pos = 1;
        if (pos > 2) pos = 2;
    } else {
        if (pos >= op_length) pos = 0;
        if (pos < 0) pos = op_length - 1;
    }

    // Apstrādā izvēles opcijas
    if (accept_key) {
        var _sml = menu_level;

        switch (menu_level) {
            case 0: // Galvenā izvēlne
                switch (pos) {
                    case 0: // Jauna spēle
                        reset_game(); // Atiestatīt spēles stāvokli
                        menu_level = 6; // Pāriet uz vārda ievades apakšizvēlni
                        keyboard_string = ""; // Atiestatīt ievades virkni
                        break;
                    case 1: // Ielādēt spēli
                        if (load_game()) {
                            room_goto(rm_level1); // Turpināt ar saglabātu istabu
                        } else {
                            show_message("No save file found!");
                        }
                        break;
                    case 2: // Uzstādījumi
                        menu_level = 1;
                        break;
                    case 3: // Rezultātu tabula
                        menu_level = 3;
                        break;
                    case 4: // Iziet no spēles
                        game_end();
                        break;
                }
                break;

            case 1: // Uzstādījumu izvēlne
                switch (pos) {
                    case 0: menu_level = 2; break; // Loga izmērs
                    case 1: menu_level = 5; break; // Vadība
                    case 2: menu_level = 4; break; // Mērķis
                    case 3: menu_level = 0; break; // Atpakaļ uz galveno izvēlni
                }
                break;

            case 2: // Loga izmēra apakšizvēlne
                switch (pos) {
                    case 0:
                        if (option[2][0] == "Window Size: 1x") {
                            option[2][0] = "Window Size: 2x";
                            window_set_size(1024, 768);
                        } else if (option[2][0] == "Window Size: 2x") {
                            option[2][0] = "Window Size: 3x";
                            window_set_size(1536, 1024);
                        } else {
                            option[2][0] = "Window Size: 1x";
                            window_set_size(864, 648);
                        }
                        break;
                    case 1:
                        global.fullscreen_enabled = !global.fullscreen_enabled;
                        window_set_fullscreen(global.fullscreen_enabled);
                        break;
                    case 2: menu_level = 1; break; // Atpakaļ uz uzstādījumiem
                }
                break;

            case 3: // Rezultātu tabulas izvēlne
                if (pos == array_length(option[3]) - 1) {
                    menu_level = 0; // Atpakaļ uz galveno izvēlni
                }
                break;

            case 4: // Mērķa apakšizvēlne
                if (pos == 1) menu_level = 1; // Atpakaļ uz uzstādījumiem
                break;

            case 5: // Vadības apakšizvēlne
                if (pos == 6) menu_level = 1; // Atpakaļ uz uzstādījumiem
                break;

            case 6: // Vārda ievades apakšizvēlne
                switch (pos) {
                    case 1: // Pieņemt
                        // Saglabā ievadīto vārdu
                        global.player_name = keyboard_string;
                        name_input_active = false; // Iziet no ievades režīma
                        room_goto(rm_level1); // Turpināt spēli
                        break;
                    case 2: // Atpakaļ
                        global.player_name = ""; // Atiestatīt vārdu, ja atcelts
                        menu_level = 0; // Atgriezties uz galveno izvēlni
                        break;
                }
                break;
        }

        // Atiestata pozīciju un pārrēķina izmēru, kad izvēlne mainās
        if (_sml != menu_level) {
            pos = 0;
            calculate_menu_size();
        }
    }
    
}
// Atskaņot skaņu, navigējot
if (pos != last_selected) {
    audio_play_sound(snd_select, 1, false);
    last_selected = pos;
}
